/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.MOCapabilities;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class HWMessagesExistProperty
implements PropertyChangeListener {
    private static final String TRACE_MASKT = "XHWMSGPT";
    private static final String TRACE_MASKF = "XHWMSGPF";
    private static final String TRACE_MASKD = "XHWMSGPD";
    private static HWMessagesExistProperty hwMessagesExistProperty;
    private PropertyChangeSupport propertyChangeSupport;
    private LinkedList hwMessagesExistList = new LinkedList();
    private boolean oldHWMessagesExistResult = false;
    private boolean newHWMessagesExistResult = false;
    private static ManagedObjectManager mom;
    public static final String HW_MESSAGES_EXIST_PROPERTY = "HWMessagesExistProperty";

    private HWMessagesExistProperty() {
        Trace.trace(TRACE_MASKT, "<> HWMessagesExistProperty.HWMessagesExistProperty()");
    }

    public static HWMessagesExistProperty getHWMessagesExistProperty() {
        Trace.trace(TRACE_MASKT, "<> HWMessagesExistProperty.getHWMessagesExistProperty()");
        return hwMessagesExistProperty;
    }

    public void addHWMessagesExistPropertyListener(PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKT, "-> HWMessagesExistProperty.addHWMessagesExistPropertyListener(listener = " + listener + ")");
        this.addHWMessagesExistPropertyListener(listener, false);
        Trace.trace(TRACE_MASKT, "<- HWMessagesExistProperty.addHWMessagesExistPropertyListener()");
    }

    public void addHWMessagesExistPropertyListener(PropertyChangeListener listener, boolean initialEvent) {
        Trace.trace(TRACE_MASKT, "-> HWMessagesExistProperty.addHWMessagesExistPropertyListener(listener = " + listener + ", " + "initialEvent = " + initialEvent + ")");
        this.propertyChangeSupport.addPropertyChangeListener(listener);
        if (initialEvent) {
            this.fireHWMessagesExistEvent();
        }
        Trace.trace(TRACE_MASKT, "<- HWMessagesExistProperty.addHWMessagesExistPropertyListener()");
    }

    public void removeHWMessagesExistPropertyListener(PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKT, "-> HWMessagesExistProperty.removeHWMessagesExistPropertyListener(listener = " + listener + ")");
        this.propertyChangeSupport.removePropertyChangeListener(listener);
        Trace.trace(TRACE_MASKT, "<- HWMessagesExistProperty.removeHWMessagesExistPropertyListener()");
    }

    private void fireHWMessagesExistEvent() {
        Trace.trace(TRACE_MASKT, "-> HWMessagesExistProperty.fireHWMessagesExistEvent()");
        if (this.newHWMessagesExistResult) {
            Trace.trace(TRACE_MASKF, "HWMessagesExistProperty.fireHWMessagesExistEvent(): Firing Hardware messages exist event.");
            PropertyChangeEvent event = new PropertyChangeEvent(this, HW_MESSAGES_EXIST_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            this.propertyChangeSupport.firePropertyChange(event);
        } else {
            Trace.trace(TRACE_MASKF, "HWMessagesExistProperty.fireHWMessagesExistEvent(): Firing Hardware messages don't exist event.");
            PropertyChangeEvent event = new PropertyChangeEvent(this, HW_MESSAGES_EXIST_PROPERTY, Boolean.TRUE, Boolean.FALSE);
            this.propertyChangeSupport.firePropertyChange(event);
        }
        Trace.trace(TRACE_MASKT, "<- HWMessagesExistProperty.fireHWMessagesExistEvent()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHWMessages() {
        Trace.trace(TRACE_MASKT, "-> HWMessagesExistgProperty.isHWMessages()");
        boolean bResult = true;
        HWMessagesExistProperty hWMessagesExistProperty = this;
        synchronized (hWMessagesExistProperty) {
            bResult = !this.hwMessagesExistList.isEmpty();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent event) {
        Trace.trace(TRACE_MASKT, "-> HWMessagesExistProperty.propertyChange(" + event + ")");
        ObjectId objectId = (ObjectId)event.getSource();
        if (objectId.equals(mom.getObjectId())) {
            ObjectId[] newValue = null;
            ObjectId[] oldValue = null;
            HWMessagesExistProperty hWMessagesExistProperty = this;
            synchronized (hWMessagesExistProperty) {
                int i;
                newValue = (ObjectId[])event.getNewValue();
                oldValue = (ObjectId[])event.getOldValue();
                if (newValue != null) {
                    for (i = 0; i < newValue.length; ++i) {
                        boolean attentionsExist = (Boolean)mom.getProperty(newValue[i], "AttentionsExist");
                        if (!attentionsExist || this.hwMessagesExistList.contains(newValue[i])) continue;
                        this.hwMessagesExistList.add(newValue[i]);
                    }
                } else {
                    for (i = 0; i < oldValue.length; ++i) {
                        if (!this.hwMessagesExistList.contains(oldValue[i])) continue;
                        this.hwMessagesExistList.remove(oldValue[i]);
                    }
                }
                this.oldHWMessagesExistResult = this.newHWMessagesExistResult;
                this.newHWMessagesExistResult = !this.hwMessagesExistList.isEmpty();
            }
            if (newValue != null) {
                for (int i = 0; i < newValue.length; ++i) {
                    mom.addPropertyChangeListener(newValue[i], "AttentionsExist", this, false);
                }
            }
        } else {
            HWMessagesExistProperty hWMessagesExistProperty = this;
            synchronized (hWMessagesExistProperty) {
                boolean attentionsExist = (Boolean)mom.getProperty(objectId, "AttentionsExist");
                if (!attentionsExist && this.hwMessagesExistList.contains(objectId)) {
                    this.hwMessagesExistList.remove(objectId);
                } else if (attentionsExist && !this.hwMessagesExistList.contains(objectId)) {
                    this.hwMessagesExistList.add(objectId);
                }
                this.oldHWMessagesExistResult = this.newHWMessagesExistResult;
                this.newHWMessagesExistResult = !this.hwMessagesExistList.isEmpty();
            }
        }
        if (this.oldHWMessagesExistResult != this.newHWMessagesExistResult) {
            this.fireHWMessagesExistEvent();
        }
        Trace.trace(TRACE_MASKT, "<- HWMessagesExistProperty.propertyChange()");
    }

    static {
        mom = ManagedObjectManager.getManagedObjectManager();
        if (hwMessagesExistProperty == null) {
            hwMessagesExistProperty = new HWMessagesExistProperty();
            HWMessagesExistProperty.hwMessagesExistProperty.propertyChangeSupport = new PropertyChangeSupport(hwMessagesExistProperty);
            Set classIds = MOCapabilities.getClassIds("HW_MESSAGES_CAPABILITIES");
            Iterator iterator = classIds.iterator();
            while (iterator.hasNext()) {
                ClassId classId = (ClassId)iterator.next();
                mom.addPropertyChangeListener((PropertyChangeListener)hwMessagesExistProperty, true, classId);
            }
        }
    }
}

